'******************************************************************************
'  ENC28J60 specific routines
'******************************************************************************
'*******************************************************************************
'  Pollin NET-IO Board with Atmega32 / 644 / 644P and ENC28J60
'*******************************************************************************
'
'  Copyright bascom-forum.de (C) [2009]  [DON]
'  -> http://bascom-forum.de/index.php?topic=1781.new;topicseen#new
'  Software based on Code by Ben Zijlstra and Viktor Varga
'  Weiterentwickelt von
'    Huetti,
'    Michael
'    boeserkorn
'    mr_energy
'    HansHans
'    six1, Michael Kcher
'    dabuze                            datetime
'    framuel
'
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'

'*******************************************************************************
$nocompile

Sub Enc28j60_reset
   Enc28j60_cs = 0
   'reset ENC28J60
   X = Enc28j60_soft_reset
   Spiout X , 1
   Enc28j60_cs = 1
   Do
   Call Enc28j60readcontrolregbyte(estat)
   X = Enc28j60_data.estat_clkrdy
   Loop Until X = 1
End Sub


Sub Enc28j60_setextclock
   'clock from default divide/4 (6.25 Mhz) to divide/2 (12.5 Mhz)
   Call Enc28j60writecontrolregbyte(ecocon , &B00000010)
   Waitms 250

End Sub


Sub Enc28j60_version
   Call Enc28j60selectbank(3)
   'EREVID
   A(1) = &B000_10010
   Enc28j60_cs = 0
   Spiout A(1) , 1
   Spiin A(1) , 2
#if System_message = 1
   Print "Enc28j60-version = " ; A(2)
#endif
   Enc28j60_cs = 1
End Sub

Sub Enc28j60_init
   Call Enc28j60_reset
   Call Enc28j60_setextclock
#if System_message = 1
   Print "-> NET-IO started, ";
#endif
   Call Enc28j60_version

   'do bank 0 stuff
   'initialize receive buffer
   '16-bit transfers, must write low byte first
   'set receive buffer start address
   Enc28j60_nextpacketptr = Rxstart_init
   Regvalue = Low(rxstart_init)
   Call Enc28j60writecontrolregbyte(erxstl , Regvalue)
   Regvalue = High(rxstart_init)
    Call Enc28j60writecontrolregbyte(erxsth , Regvalue)
    'set receive pointer address
    Regvalue = Low(rxstart_init)
    Call Enc28j60writecontrolregbyte(erxrdptl , Regvalue)
    Regvalue = High(rxstart_init)
    Call Enc28j60writecontrolregbyte(erxrdpth , Regvalue)
    'set receive buffer end
    Regvalue = Low(rxstop_init)
    Call Enc28j60writecontrolregbyte(erxndl , Regvalue)
    Regvalue = High(rxstop_init)
    Call Enc28j60writecontrolregbyte(erxndh , Regvalue)
    'set transmit buffer start
    Regvalue = Low(txstart_init)
    Call Enc28j60writecontrolregbyte(etxstl , Regvalue)
    Regvalue = High(txstart_init)
    Call Enc28j60writecontrolregbyte(etxsth , Regvalue)
    'do bank 2 stuff
    'enable MAC receive
    Regvalue = 0
    Regvalue.macon1_marxen = 1
    Regvalue.macon1_txpaus = 1
    Regvalue.macon1_rxpaus = 1
    Call Enc28j60writecontrolregbyte(macon1 , Regvalue)
    'bring MAC out of reset
    'enable automatic padding and CRC operations
    Regvalue = 0
    Regvalue.macon3_padcfg0 = 1
    Regvalue.macon3_txcrcen = 1
    Regvalue.macon3_frmlnen = 1
    Regvalue.macon3_hfrmlen = 1
    Call Enc28j60writecontrolregbyte(macon3 , Regvalue)
    'set inter-frame gap (non-back-to-back)
    Call Enc28j60writecontrolregbyte(maipgl , &H12)
    Call Enc28j60writecontrolregbyte(maipgh , &H0C)
    'set inter-frame gap (back-to-back)
    Call Enc28j60writecontrolregbyte(mabbipg , &H12)
    'set the maximum packet size which the controller will accept
    Regvalue = Low(max_framelen)
    Call Enc28j60writecontrolregbyte(mamxfll , Regvalue)
    Regvalue = High(max_framelen)
    Call Enc28j60writecontrolregbyte(mamxflh , Regvalue)

    'bank 3 stuff
    Call Enc28j60writecontrolregbyte(maadr5 , My_b_macaddr(1))
    Call Enc28j60writecontrolregbyte(maadr4 , My_b_macaddr(2))
    Call Enc28j60writecontrolregbyte(maadr3 , My_b_macaddr(3))
    Call Enc28j60writecontrolregbyte(maadr2 , My_b_macaddr(4))
    Call Enc28j60writecontrolregbyte(maadr1 , My_b_macaddr(5))
    Call Enc28j60writecontrolregbyte(maadr0 , My_b_macaddr(6))
    'no loopback of transmitted frames
    Call Enc28j60writephyword(phcon2 , Phcon2_hdldis)
    'switch to bank 0
    Call Enc28j60selectbank(0)
    'enable interrupts
    Regvalue = 0
    Regvalue.eie_intie = 1
    Regvalue.eie_pktie = 1
    Call Enc28j60bitfield_set(eie , Regvalue)
    'enable interrupt pin
    Call Enc28j60writecontrolregbyte(eie , &HC0)            'enable interrupt pin if a packet is received


    'filters according to Guido
    Call Enc28j60writecontrolregbyte(epmm0 , &H3F)
    Call Enc28j60writecontrolregbyte(epmm1 , &H30)
    Call Enc28j60writecontrolregbyte(epmcsl , &HF9)
    Call Enc28j60writecontrolregbyte(epmcsh , &HF7)

    Regvalue = 0
    Regvalue.erxfcon_pmen = 1                               'Pattern Match enable (ARP only)
    Regvalue.erxfcon_ucen = 1                               'Unicast enable
    Call Enc28j60bitfield_set(erxfcon , Regvalue)

    Regvalue = 0
    Regvalue.erxfcon_bcen = 0                               '0 = Broadcast enable --> needed for DHCP
    Call Enc28j60bitfield_clear(erxfcon , Regvalue)
    'CRC check is enabled by default

    'Something is wrong with the Broadcast filter (or the whole theory), it seems
    'like every packet is coming in

    'enable packet reception
    Regvalue = 0
    Regvalue.econ1_rxen = 1
    Call Enc28j60bitfield_set(econ1 , Regvalue)

    'Reset transmit logic
    Regvalue = 0
    Regvalue.econ1_txrst = 1
    Call Enc28j60bitfield_set(econ1 , Regvalue)
    Call Enc28j60bitfield_clear(econ1 , Regvalue)
 End Sub


Sub Enc28j60selectbank(bank As Byte)
   'get ECON1 (BSEL1 en BSEL0)
   A(1) = &B000_11111
   Enc28j60_cs = 0
   Spiout A(1) , 1
   Spiin A(1) , 2
   Enc28j60_cs = 1
   A(2) = A(2) And &B1111_1100                              'strip bank part
   A(2) = A(2) Or Bank
   A(1) = &B010_11111
   Enc28j60_cs = 0
   Spiout A(1) , 2
   Enc28j60_cs = 1
End Sub


Sub Enc28j60writecontrolregbyte(register As Byte , Regvalue As Byte)
   Bank = 0
   If Register.7 = 1 Then Bank = 2
   If Register.6 = 1 Then Bank = Bank + 1
   Register = Register And &B00011111
   Call Enc28j60selectbank(bank)
   Register.6 = 1                                           'to get a 010_register
   A(1) = Register
   A(2) = Regvalue
   Enc28j60_cs = 0
   Spiout A(1) , 2
   Enc28j60_cs = 1
End Sub


Sub Enc28j60readcontrolregbyte(register As Byte)
   Local Mcphy As Byte
   Bank = 0
   Mcphy = 0
   If Register.7 = 1 Then Bank = 2
   If Register.6 = 1 Then Bank = Bank + 1
   If Register.5 = 1 Then Mcphy = 1
   Register = Register And &B00011111
   Call Enc28j60selectbank(bank)
   A(1) = Register
   Enc28j60_cs = 0
   Spiout A(1) , 1
   Spiin A(1) , 3
   Enc28j60_cs = 1
   'Depending of register (E, MAC, MII) yes or no dummybyte
   If Mcphy = 1 Then
      Enc28j60_data = A(2)
      Else
      Enc28j60_data = A(1)                                  '1.11.9.3  A(1) not A(3)
   End If
End Sub


Sub Enc28j60bitfield_set(register As Byte , Regvalue As Byte)
   Bank = 0
   If Register.7 = 1 Then Bank = 2
   If Register.6 = 1 Then Bank = Bank + 1
   Register = Register And &B00011111
   Call Enc28j60selectbank(bank)
   Register = Register Or &B100_00000
   A(1) = Register
   A(2) = Regvalue
   Enc28j60_cs = 0
   Spiout A(1) , 2
   Enc28j60_cs = 1
End Sub


Sub Enc28j60bitfield_clear(register As Byte , Regvalue As Byte)
   Bank = 0
   If Register.7 = 1 Then Bank = 2
   If Register.6 = 1 Then Bank = Bank + 1
   Register = Register And &B00011111
   Call Enc28j60selectbank(bank)
   Register = Register Or &B101_00000
   A(1) = Register
   A(2) = Regvalue
   Enc28j60_cs = 0
   Spiout A(1) , 2
   Enc28j60_cs = 1
End Sub


Sub Enc28j60readphyword(phyregister As Byte)
   'set the right address and start the register read operation
   Call Enc28j60writecontrolregbyte(miregadr , Phyregister)
   Call Enc28j60writecontrolregbyte(micmd , Micmd_miird)
   'wait until the PHY read complets
   Do
   Call Enc28j60readcontrolregbyte(mistat)
   Loop Until Enc28j60_data.mistat_busy = 0
   'quit reading
   Call Enc28j60writecontrolregbyte(micmd , 0)
   'get data value
   Call Enc28j60readcontrolregbyte(mirdl)
   Phyword = Enc28j60_data
   Shift Phyword , Left , 8
   Call Enc28j60readcontrolregbyte(mirdh)
   Phyword = Phyword + Enc28j60_data
End Sub


Sub Enc28j60writephyword(phyregister As Byte , Phyword As Word)
   Call Enc28j60readphyword(phyregister)
   Local Temp As Byte
   'set the PHY register address
   Call Enc28j60writecontrolregbyte(miregadr , Phyregister)
   Call Enc28j60readcontrolregbyte(miregadr)
   Temp = Miregadr
   Regvalue = Low(phyword)
   Call Enc28j60writecontrolregbyte(miwrl , Regvalue)
   Regvalue = High(phyword)
   Call Enc28j60writecontrolregbyte(miwrh , Regvalue)
   Do
   Call Enc28j60readcontrolregbyte(mistat)
   Loop Until Enc28j60_data.mistat_busy = 0
End Sub


Sub Enc28j60packetreceive
Local L_packetlength As Word
   'set the read pointer to the start of the received packet
   Regvalue = Low(enc28j60_nextpacketptr)
   Call Enc28j60writecontrolregbyte(erdptl , Regvalue)
   Regvalue = High(enc28j60_nextpacketptr)
   Call Enc28j60writecontrolregbyte(erdpth , Regvalue)
    Enc28j60_cs = 0
    'Send Read Buffer Memory command
    Spdr = &H3A
    Call Enc28j60waitforspiready
    'Get the first 6 byte (3 word: Enc28j60_Nextpacketptr, L_Packetlength, Rxstat)
    For X = 1 To 6
          Spdr = &HFF                                       'SPI read
          Call Enc28j60waitforspiready
          Buffer(x) = Spdr
    Next X
    Enc28j60_nextpacketptr = Buffer(2) * 256
    Enc28j60_nextpacketptr = Enc28j60_nextpacketptr + Buffer(1)
    L_packetlength = Buffer(4) * 256
    L_packetlength = L_packetlength + Buffer(3)
    Rxstat = Buffer(6) * 256
    Rxstat = Rxstat + Buffer(5)
    'Get the payload
    L_packetlength = L_packetlength - 4                     'Discard CRC
    For X = 1 To L_packetlength
          Spdr = &HFF                                       'SPI read
          Call Enc28j60waitforspiready
          Buffer(x) = Spdr
    Next X
    Enc28j60_cs = 1
   'move the rx read pointer to the start of the next received packet
   'this frees the memory we just read out
   Regvalue = Low(enc28j60_nextpacketptr)
   Call Enc28j60writecontrolregbyte(erxrdptl , Regvalue)
   Regvalue = High(enc28j60_nextpacketptr)
   Call Enc28j60writecontrolregbyte(erxrdpth , Regvalue)
   'decrement the packet counter indicate we are done with this packet
   Regvalue = 0
   Regvalue.econ2_pktdec = 1
   Call Enc28j60bitfield_set(econ2 , Regvalue)

End Sub


Sub Enc28j60packetsend(byval Pcktlen As Word)
   'Load packet into the ENC
   Enc28j60_cs = 0
   Spdr = Enc28j60_write_buf_mem
   Call Enc28j60waitforspiready
   Spdr = &B000_1110                                        'per packet byte
   Call Enc28j60waitforspiready
   For X = 1 To Pcktlen
      Spdr = Buffer(x)
      Call Enc28j60waitforspiready
   Next X
   Enc28j60_cs = 1
   'Minimum packet length is 60
   If Pcktlen < 60 Then Pcktlen = 60
   'Reset transmit logic
   Regvalue = 0
   Regvalue.econ1_txrst = 1
   Call Enc28j60bitfield_set(econ1 , Regvalue)
   Call Enc28j60bitfield_clear(econ1 , Regvalue)
   'set the write pointer to start of transmit buffer area
   Regvalue = Low(txstart_init)
   Call Enc28j60writecontrolregbyte(ewrptl , Regvalue)
   Regvalue = High(txstart_init)
   Call Enc28j60writecontrolregbyte(ewrpth , Regvalue)
   'set the TXND pointer to correspond to the packet size given
   Regvalue = Low(txstart_init)
   Regvalue = Regvalue + Low(pcktlen)
   Call Enc28j60writecontrolregbyte(etxndl , Regvalue)
   Regvalue = High(txstart_init)
   Regvalue = Regvalue + High(pcktlen)
   Call Enc28j60writecontrolregbyte(etxndh , Regvalue)
   'write per-packet control byte has been put in the writeroutine
   'send the contents of the transmit buffer onto the network
   Regvalue = 0
   Regvalue.econ1_txrts = 1
   Call Enc28j60bitfield_set(econ1 , Regvalue)
End Sub

Sub Enc28j60waitforspiready
#if _chip = 23                                              'ATMega32
   Do
   Loop Until Spsr.spif = 1
#endif
#if _chip = 37                                              'ATMega644
   Do
   Loop Until Spsr0.spif0 = 1
#endif
#if _chip = 59                                              'ATMega644P
   Do
   Loop Until Spsr0.spif0 = 1
#endif
#if _chip = 103                                             'ATMega1284P
   Do
   Loop Until Spsr0.spif0 = 1
#endif
End Sub


Sub Enc28j60disableinterrupt
   Call Enc28j60writecontrolregbyte(eie , &H40)             'disable the ENC28J60 int Pin
End Sub

Sub Enc28j60enableinterrupt
   Call Enc28j60writecontrolregbyte(eie , &HC0)             'enable the ENC28J60 int PIN
End Sub